/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import jemu.system.cpc.CPC;

public class GraphicsDecoder {
    public byte[] decoded;

    public byte[] getDecoded(int address, int mode, boolean write) {
        this.decoded = new byte[8];
        try {
            if (write) {
                this.decodeFull(this.decoded, 0, mode, CPC.memory.readWriteByte(address));
            } else {
                this.decodeFull(this.decoded, 0, mode, CPC.memory.readByte(address));
            }
        }
        catch (Exception e) {
            this.decodeFull(this.decoded, 0, mode, 128);
        }
        return this.decoded;
    }

    public byte[] getReverseDecoded(int address, int mode, boolean write) {
        this.decoded = new byte[8];
        try {
            if (write) {
                this.decodeReverseFull(this.decoded, 0, mode, CPC.memory.readWriteByte(address));
            } else {
                this.decodeReverseFull(this.decoded, 0, mode, CPC.memory.readByte(address));
            }
        }
        catch (Exception e) {
            this.decodeFull(this.decoded, 0, mode, 128);
        }
        return this.decoded;
    }

    public byte[] getDecodedLinear(int address, int mode, boolean write) {
        this.decoded = new byte[8];
        try {
            if (write) {
                this.decodeLinear(this.decoded, 0, mode, CPC.memory.readWriteByte(address));
            } else {
                this.decodeLinear(this.decoded, 0, mode, CPC.memory.readByte(address));
            }
        }
        catch (Exception e) {
            this.decodeLinear(this.decoded, 0, mode, 128);
        }
        return this.decoded;
    }

    public int[] pixelcolor(int address, int mode, boolean write) {
        this.decoded = this.getDecoded(address, mode, write);
        int[] col = new int[8];
        for (int i = 0; i < 8; ++i) {
            col[i] = this.decoded[i];
        }
        return col;
    }

    public int[] pixelreversecolor(int address, int mode, boolean write) {
        this.decoded = this.getReverseDecoded(address, mode, write);
        int[] col = new int[8];
        for (int i = 0; i < 8; ++i) {
            col[i] = this.decoded[i];
        }
        return col;
    }

    public int[] pixellinear(int address, int mode, boolean write) {
        this.decoded = this.getDecodedLinear(address, mode, write);
        int[] col = new int[8];
        for (int i = 0; i < 8; ++i) {
            col[i] = this.decoded[i];
        }
        return col;
    }

    protected final void decodeFull(byte[] map, int offs, int mode, int b) {
        switch (mode) {
            case 0: {
                map[offs + 3] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs + 2] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs + 1] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs + 7] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                map[offs + 6] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                map[offs + 5] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                map[offs + 4] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                break;
            }
            case 1: {
                map[offs + 1] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 3] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 2] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 5] = (byte)((b & 0x20) >> 5 | b & 2);
                map[offs + 4] = (byte)((b & 0x20) >> 5 | b & 2);
                map[offs + 7] = (byte)((b & 0x10) >> 4 | (b & 1) << 1);
                map[offs + 6] = (byte)((b & 0x10) >> 4 | (b & 1) << 1);
                break;
            }
            case 2: {
                map[offs++] = (byte)((b & 0x80) >> 7);
                map[offs++] = (byte)((b & 0x40) >> 6);
                map[offs++] = (byte)((b & 0x20) >> 5);
                map[offs++] = (byte)((b & 0x10) >> 4);
                map[offs++] = (byte)((b & 8) >> 3);
                map[offs++] = (byte)((b & 4) >> 2);
                map[offs++] = (byte)((b & 2) >> 1);
                map[offs] = (byte)(b & 1);
                break;
            }
            case 3: {
                map[offs + 3] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 2] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 1] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 7] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 6] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 5] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 4] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
            }
        }
    }

    protected final void decodeReverseFull(byte[] map, int offs, int mode, int b) {
        switch (mode) {
            case 0: {
                map[offs + 7] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs + 6] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs + 5] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs + 4] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs + 3] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                map[offs + 2] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                map[offs + 1] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                map[offs] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                break;
            }
            case 1: {
                map[offs + 7] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 6] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 5] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 4] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 3] = (byte)((b & 0x20) >> 5 | b & 2);
                map[offs + 2] = (byte)((b & 0x20) >> 5 | b & 2);
                map[offs + 1] = (byte)((b & 0x10) >> 4 | (b & 1) << 1);
                map[offs] = (byte)((b & 0x10) >> 4 | (b & 1) << 1);
                break;
            }
            case 2: {
                map[offs++] = (byte)((b & 2) >> 1);
                map[offs++] = (byte)((b & 4) >> 2);
                map[offs++] = (byte)((b & 8) >> 3);
                map[offs++] = (byte)((b & 0x10) >> 4);
                map[offs++] = (byte)((b & 0x20) >> 5);
                map[offs++] = (byte)((b & 0x40) >> 6);
                map[offs++] = (byte)((b & 0x80) >> 7);
                map[offs] = (byte)(b & 1);
                break;
            }
            case 3: {
                map[offs + 7] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 6] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 5] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 4] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 3] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 2] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 1] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
            }
        }
    }

    public final void decodeHalf(byte[] map, int offs, int mode, int b) {
        switch (mode) {
            case 0: {
                map[offs + 1] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs + 3] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                map[offs + 2] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                break;
            }
            case 1: {
                map[offs++] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs++] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs++] = (byte)((b & 0x20) >> 5 | b & 2);
                map[offs] = (byte)((b & 0x10) >> 4 | (b & 1) << 1);
                break;
            }
            case 2: {
                map[offs++] = (byte)((b & 0x80) >> 7);
                map[offs++] = (byte)((b & 0x20) >> 5);
                map[offs++] = (byte)((b & 8) >> 3);
                map[offs] = (byte)((b & 2) >> 1);
                break;
            }
            case 3: {
                map[offs + 1] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 3] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 2] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
            }
        }
    }

    protected final void decodeLinear(byte[] map, int offs, int mode, int b) {
        switch (mode) {
            case 0: {
                map[offs + 3] = (byte)((b & 0x80) >> 4 | (b & 0x40) >> 4 | (b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 2] = (byte)((b & 0x80) >> 4 | (b & 0x40) >> 4 | (b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 1] = (byte)((b & 0x80) >> 4 | (b & 0x40) >> 4 | (b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs] = (byte)((b & 0x80) >> 4 | (b & 0x40) >> 4 | (b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 7] = (byte)(b & 8 | b & 4 | b & 1 | b & 2);
                map[offs + 6] = (byte)(b & 8 | b & 4 | b & 1 | b & 2);
                map[offs + 5] = (byte)(b & 8 | b & 4 | b & 1 | b & 2);
                map[offs + 4] = (byte)(b & 8 | b & 4 | b & 1 | b & 2);
                break;
            }
            case 1: {
                map[offs + 1] = (byte)((b & 0x80) >> 6 | (b & 0x40) >> 6);
                map[offs + 0] = (byte)((b & 0x80) >> 6 | (b & 0x40) >> 6);
                map[offs + 3] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 2] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 5] = (byte)((b & 8) >> 2 | (b & 4) >> 2);
                map[offs + 4] = (byte)((b & 8) >> 2 | (b & 4) >> 2);
                map[offs + 7] = (byte)(b & 2 | b & 1);
                map[offs + 6] = (byte)(b & 2 | b & 1);
                break;
            }
            case 2: {
                map[offs++] = (byte)((b & 0x80) >> 7);
                map[offs++] = (byte)((b & 0x40) >> 6);
                map[offs++] = (byte)((b & 0x20) >> 5);
                map[offs++] = (byte)((b & 0x10) >> 4);
                map[offs++] = (byte)((b & 8) >> 3);
                map[offs++] = (byte)((b & 4) >> 2);
                map[offs++] = (byte)((b & 2) >> 1);
                map[offs] = (byte)(b & 1);
                break;
            }
            case 3: {
                map[offs + 3] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 2] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 1] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 7] = (byte)(b & 2 | b & 1);
                map[offs + 6] = (byte)(b & 2 | b & 1);
                map[offs + 5] = (byte)(b & 2 | b & 1);
                map[offs + 4] = (byte)(b & 2 | b & 1);
            }
        }
    }
}

